import re
import sys
sys.path.append("../utils")

# Types of yml files in the documentation -->

# 1) class - name, summary, remarks, methods(name, summary, syntax, uid, remarks), properties(name, summary, syntax, uid, remarks)

# 2) enum - name, summary, remarks, fields(name, summary, uid)

# 3) interface - name, summary, remarks, properties(name, summary, syntax, uid, remarks)

# 4) type - name, summary, syntax, remarks


class DocumentationNode:
    def __init__(self, yaml_dict):
        self.name = yaml_dict['name']
        self.type = yaml_dict['uid'].split(":")[-1]
        self.summary = yaml_dict['summary']
        self.syntax = None
        self.fields = None
        self.properties = None
        self.methods = None
        self.examples = None
        self.valid_top_level = False
        
        if 'syntax' in yaml_dict:
            self.syntax = yaml_dict['syntax']
        if 'fields' in yaml_dict:
            self.fields = self.extracting_fields(yaml_dict['fields'])
        if 'properties' in yaml_dict:
            self.properties = self.extracting_properties(yaml_dict['properties'])
        if 'methods' in yaml_dict:
            self.methods = self.extracting_methods(yaml_dict['methods'])
        if 'remarks' in yaml_dict:
            self.examples = self.extracting_examples(yaml_dict['remarks'])


    def extracting_properties(self, property_list):
        pattern = r'<xref uid="(.*?)" />'
        for property in property_list:
            property['examples'] = ''
            if 'remarks' in property:
                property['examples'] = self.extracting_examples(property['remarks'])
            try:
                matches = re.findall(pattern, property['syntax']['return']['type'])
                property['uid'] = matches[0]
            except:
                continue
        return [{
            'name' : m['name'],
            'summary' : m['summary'],
            'syntax' : m['syntax'],
            'uid' : m['uid'],
            'examples' : m['examples']
          } for m in property_list]
        # properties syntax has - (content, return)

    def extracting_methods(self, methods_list):
        pattern = r'<xref uid="(.*?)" />'
        for methods in methods_list:
            methods['examples'] = ''
            if 'remarks' in methods:
                methods['examples'] = self.extracting_examples(methods['remarks'])
            uid_list = []
            if 'parameters' in methods['syntax']:
                param_list = methods['syntax']['parameters']
                if not isinstance(param_list, list):
                    param_list = [methods['syntax']['parameters']]
                for p in param_list:
                    matches = re.findall(pattern, p['type'])
                    if matches:
                        uid_list.append(matches[0])
            if 'return' in methods['syntax']:
                matches = re.findall(pattern, methods['syntax']['return']['type'])
                if matches:
                    uid_list.append(matches[0])
            methods['uid'] = uid_list
            
        return [{
            'name' : m['name'],
            'summary' : m['summary'],
            'syntax' : m['syntax'],
            'uid' : m['uid'],
            'examples' : m['examples']
          } for m in methods_list]
        # has content, parameters, return
    
    def extracting_fields(self, fields_list):
        return [{
            'name' : m['name'],
            'summary' : m['summary'],
            'uid' : m['uid']
          } for m in fields_list]
        # for enums, uid should be None (no outward edges from this node)
    
    def extracting_examples(self, remarks : str) -> str:
        pattern = re.compile(r'```TypeScript(.*?)```', re.DOTALL)
        match = re.search(pattern, remarks)
        if not match:
            return ''
        extracted_code = match.group(1).strip()
        extracted_code = extracted_code[extracted_code.find("function main(workbook: ExcelScript.Workbook)"):]
        extracted_code = re.sub(r"//.*?\n|/\*.*?\*/", "", extracted_code, flags=re.DOTALL)
        return extracted_code